<?xml version="1.0" encoding="UTF-8"?>
<!-- El objetivo de este archivo SLD, es el de simbolizar la entidad urbanística correspondiente según lo indicado en la "Instrucción técnica de estandarización y normalización de instrumentos de planeamiento (ITU-PL1)". Antes de su uso deberá revisar las etiquetas que hacen referencia a los campos existentes en las tablas de datos, especialmente los destinados a simbolizar por categorías, los de elementos alfanuméricos y los de geometría. Su definición puede admitir variantes y ser mejorada. Si es el caso, por favor, comparta su conocimiento para que futuros usuarios puedan beneficiarse. Gracias. | Murcia, mayo de 2024 | SERVICIO DE URBANISMO | https://www.urbmurcia.es/web/urbmurcia/contacto | -->
<sld:StyledLayerDescriptor xmlns="http://www.opengis.net/sld" xmlns:sld="http://www.opengis.net/sld" xmlns:ogc="http://www.opengis.net/ogc" xmlns:gml="http://www.opengis.net/gml" version="1.0.0">
	<sld:NamedLayer>
		<sld:Name>20_areas_sin_sectorizar</sld:Name>
		<sld:UserStyle>
			<sld:Name>20_areas_sin_sectorizar</sld:Name>
			<sld:FeatureTypeStyle>
				<sld:Name>poligono</sld:Name>
				<sld:Title>Áreas sin sectorizar</sld:Title>
				<sld:Abstract/>
				<sld:Rule>
					<sld:Name>Áreas sin sectorizar</sld:Name>
					<sld:Title>Áreas sin sectorizar</sld:Title>
					<sld:Abstract/>
					<!-- <sld:MinScaleDenominator>1000.0</sld:MinScaleDenominator> -->
					<!-- <sld:MaxScaleDenominator>5000.0</sld:MaxScaleDenominator> -->
					<sld:PolygonSymbolizer>
						<sld:Stroke>
							<sld:CssParameter name="stroke">#D2DC14</sld:CssParameter>
							<sld:CssParameter name="stroke-width">2.5</sld:CssParameter>
							<sld:CssParameter name="stroke-dasharray">10 5</sld:CssParameter>
						</sld:Stroke>
					</sld:PolygonSymbolizer>
					<sld:TextSymbolizer>
						<sld:Label>
							<ogc:PropertyName>Área_en_urbanizable</ogc:PropertyName>
						</sld:Label>
						<sld:Font>
							<sld:CssParameter name="font-family">Liberation Mono</sld:CssParameter>
							<sld:CssParameter name="font-size">12</sld:CssParameter>
							<sld:CssParameter name="font-style">normal</sld:CssParameter>
							<sld:CssParameter name="font-weight">normal</sld:CssParameter>
						</sld:Font>
						<sld:LabelPlacement>
							<sld:PointPlacement>
								<sld:AnchorPoint>
									<sld:AnchorPointX>0.5</sld:AnchorPointX>
									<sld:AnchorPointY>0.5</sld:AnchorPointY>
								</sld:AnchorPoint>
								<sld:Displacement>
									<sld:DisplacementX>0.0</sld:DisplacementX>
									<sld:DisplacementY>0.0</sld:DisplacementY>
								</sld:Displacement>
							</sld:PointPlacement>
						</sld:LabelPlacement>
						<sld:Halo>
							<sld:Radius>2.0</sld:Radius>
							<sld:Fill>
								<sld:CssParameter name="fill">#D2DC14</sld:CssParameter>
							</sld:Fill>
						</sld:Halo>
						<sld:Fill>
							<sld:CssParameter name="fill">#000000</sld:CssParameter>
						</sld:Fill>
					</sld:TextSymbolizer>
				</sld:Rule>
				<sld:Rule>
					<sld:Name>SA</sld:Name>
					<sld:Title>(SA) Uso residencial alta densidad</sld:Title>
					<sld:Abstract/>
					<!-- <sld:MinScaleDenominator>1000.0</sld:MinScaleDenominator> -->
					<!-- <sld:MaxScaleDenominator>5000.0</sld:MaxScaleDenominator> -->
				</sld:Rule>
				<sld:Rule>
					<sld:Name>SM</sld:Name>
					<sld:Title>(SM) Uso residencial media densidad</sld:Title>
					<sld:Abstract/>
					<!-- <sld:MinScaleDenominator>1000.0</sld:MinScaleDenominator> -->
					<!-- <sld:MaxScaleDenominator>5000.0</sld:MaxScaleDenominator> -->
				</sld:Rule>
				<sld:Rule>
					<sld:Name>SB</sld:Name>
					<sld:Title>(SB) Uso residencial baja densidad</sld:Title>
					<sld:Abstract/>
					<!-- <sld:MinScaleDenominator>1000.0</sld:MinScaleDenominator> -->
					<!-- <sld:MaxScaleDenominator>5000.0</sld:MaxScaleDenominator> -->
				</sld:Rule>
				<sld:Rule>
					<sld:Name>SU</sld:Name>
					<sld:Title>(SU) Uso residencial mínima densidad</sld:Title>
					<sld:Abstract/>
					<!-- <sld:MinScaleDenominator>1000.0</sld:MinScaleDenominator> -->
					<!-- <sld:MaxScaleDenominator>5000.0</sld:MaxScaleDenominator> -->
				</sld:Rule>
				<sld:Rule>
					<sld:Name>SP</sld:Name>
					<sld:Title>(SP) Uso actividad económica</sld:Title>
					<sld:Abstract/>
					<!-- <sld:MinScaleDenominator>1000.0</sld:MinScaleDenominator> -->
					<!-- <sld:MaxScaleDenominator>5000.0</sld:MaxScaleDenominator> -->
				</sld:Rule>
				<sld:Rule>
					<sld:Name>SE</sld:Name>
					<sld:Title>(SE) Urbanizable especial sin sectorizar</sld:Title>
					<sld:Abstract/>
					<!-- <sld:MinScaleDenominator>1000.0</sld:MinScaleDenominator> -->
					<!-- <sld:MaxScaleDenominator>5000.0</sld:MaxScaleDenominator> -->
				</sld:Rule>
			</sld:FeatureTypeStyle>
		</sld:UserStyle>
	</sld:NamedLayer>
</sld:StyledLayerDescriptor>
